import { API_END_POINTS } from "@/services/ApiEndpoints";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

const initialState = {
  courseToEnroll: null,
};

export const courseToEnroll = createAsyncThunk(
  "enrolledCourses/courseToEnroll",
  async (courseId, { getState }) => {
    const token = getState().auth?.token;
    try {
      const response = await fetch(API_END_POINTS.addInEnrolled, {
        headers: {
          Authorization: `Bearer ${token}`,
          "Content-Type": "application/json",
        },
        method: "POST",
        body: JSON.stringify({ course_id: courseId }),
      });
      if (!response.ok) throw new Error("Failed to fetch enrolled courses");
      return await response.json();
    } catch (error) {
      console.log(error);
      throw error;
    }
  }
);

const courseToEnrolledSlice = createSlice({
  name: "courseToEnrolled",
  initialState,
  reducers: {
    setCourseToEnroll: (state, action) => {
      state.courseToEnroll = action.payload;
    },
  },
  extraReducers: (builder) => {
    builder.addCase(courseToEnroll.fulfilled, (state, action) => {
      state.courseToEnroll = action.payload;
    });
  },
});

export const { setCourseToEnroll } = courseToEnrolledSlice.actions;
export default courseToEnrolledSlice.reducer;
